<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Courrier extends Model 
{

    protected $table = 'courrier';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function typecourrier()
    {
        return $this->belongsTo(' App\Models\Typecourrier', 'typecourrier_id');
    }

    public function utilisateur()
    {
        return $this->belongsToMany(' App\Models\Utilisateur');
    }

    public function etat()
    {
        return $this->belongsTo(' App\Models\Etat', 'etat_id');
    }

    public function delaistraitement()
    {
        return $this->belongsTo('App\Models\Delaistraitement', 'delaistraitement_id');
    }

    public function notification()
    {
        return $this->belongsTo('Notification', 'notification_id');
    }

    public function achives()
    {
        return $this->belongsTo(' App\Models\Achive', 'achive_id');
    }

    public function fichiers()
    {
        return $this->hasMany(' App\Models\Fichier');
    }

}